unit Unit1;

//      ,   
//  .    
//       Image     .
//        
// Image    .  ,  ALT 
//   .

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls;

type
  TForm1 = class(TForm)
    Label1: TLabel;
    Panel1: TPanel;
    Image1: TImage;
    Panel2: TPanel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    CbBoxFigure: TComboBox;
    StTxtBColor: TStaticText;
    StTxtPColor: TStaticText;
    CbBoxBStyle: TComboBox;
    CbBoxPicStyle: TComboBox;
    ColorDialog1: TColorDialog;
    BttClear: TButton;
    CbBoxREItem: TComboBox;
    StTxtCnvColor: TStaticText;

    procedure StTxtBColorClick(Sender: TObject);
    procedure StTxtPColorClick(Sender: TObject);
    procedure Image1MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure FormCreate(Sender: TObject);
    procedure BttClearClick(Sender: TObject);
    procedure Image1MouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure Image1MouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure StTxtCnvColorClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    procedure ShowFigure(XB, YB, XE, YE : Integer);
  end;

var
  Form1: TForm1;

//var  ArrPnt     : array [0..3] of TPoint;

implementation

{$R *.dfm}

var
    CnvColor         : TColor;      //  
    bColor           : TColor;      //   
    pColor           : TColor;      //  
    SavePenMode      : TPenMode;    //   PenMode
    XB, YB           : Integer;     //   
    XE, YE           : Integer;     //   
    Elastic          : Boolean;     //   
    ElasticShow      : Boolean;     //    
    RqOrient         : char;        //  'H'/'V'

type TDrStyle = (drMoveTo, drLineTo);
type TDrPoint = packed record
    DM  : TDrStyle;  //  
    X  : integer;    // X - 
    Y  : integer;    // Y - 
end;

//   
const DrResH : array [0..7] of TDrPoint =
(
  (DM : drLineTo; X : 20; Y :  0 ),
  (DM : drLineTo; X : 20; Y : -5 ),
  (DM : drLineTo; X : 40; Y : -5 ),
  (DM : drLineTo; X : 40; Y :  5 ),
  (DM : drLineTo; X : 20; Y :  5 ),
  (DM : drLineTo; X : 20; Y :  0 ),
  (DM : drMoveTo; X : 40; Y :  0 ),
  (DM : drLineTo; X : 60; Y :  0 )
);

//   
const DrCapH : array [0..6] of TDrPoint =
(
  (DM : drLineTo; X : 20; Y :  0  ),
  (DM : drMoveTo; X : 20; Y : -10 ),
  (DM : drLineTo; X : 20; Y :  10 ),
  (DM : drMoveTo; X : 26; Y : -10 ),
  (DM : drLineTo; X : 26; Y :  10 ),
  (DM : drMoveTo; X : 26; Y :  0 ),
  (DM : drLineTo; X : 46; Y :  0 )
);

//       XB, YB
procedure DrawRItem (RqCnv  : TCanvas; RqDrArr : array of TDrPoint;
                     XB, YB : integer; RqOrient : char);
var Ind : integer;
begin
   RqCnv.MoveTo(XB, YB);
   for Ind := Low(RqDrArr) to High(RqDrArr) do
   with RqDrArr[Ind] do
     case DM of
     drMoveTo : case RqOrient of
                'H' : RqCnv.MoveTo(XB + X, YB + Y);
                'V' : RqCnv.MoveTo(XB + Y, YB + X);
                end;
     drLineTo : case RqOrient of
                'H' : RqCnv.LineTo(XB + X, YB + Y);
                'V' : RqCnv.LineTo(XB + Y, YB + X);
                end;
     end;
end;

//     
procedure TForm1.ShowFigure(XB, YB, XE, YE : Integer);
begin
  with Image1.Canvas do
  begin
    //     Color  Width
    Pen.Style   := psSolid;
    Pen.Color   := pColor;
    Pen.Width   := 1;
    //     Color  Style
    Brush.Color := bColor;
    case CbBoxBStyle.ItemIndex of
    0 : Brush.Style := bsClear;
    1 : Brush.Style := bsSolid;
    2 : Brush.Style := bsHorizontal;
    3 : Brush.Style := bsVertical;
    4 : Brush.Style := bsCross;
    5 : Brush.Style := bsBDiagonal;
    6 : Brush.Style := bsFDiagonal;
    7 : Brush.Style := bsDiagCross;
    end;
    //   Rectangle, RoundRect, Ellipse
    case CbBoxFigure.ItemIndex of
    0 : Rectangle(XB, YB, XE, YE);
    1 : RoundRect(XB, YB, XE, YE, Abs(XE - XB) div 3, Abs(YE - YB) div 3);
    2 : Ellipse(XB, YB, XE, YE);
    end;
  end; // of with Image1.Canvas
end;

//    Image
procedure ClearImage(RqImg : TImage);
begin
  with RqImg.Canvas do
  begin
     //     
     Brush.Color := CnvColor;
     Pen.Color   := CnvColor;
     Pen.Style   := psSolid;
     // 
     Brush.Style := bsSolid;
     Rectangle(0, 0, RqImg.Width, RqImg.Height);
  end; // of with RqImg.Canvas
end;

//   Image
procedure TForm1.BttClearClick(Sender: TObject);
begin
   ClearImage(Image1);
end;

//    
procedure TForm1.StTxtCnvColorClick(Sender: TObject);
begin
  if ColorDialog1.Execute
  then begin
    CnvColor := ColorDialog1.Color;   //  
    StTxtCnvColor.Color := CnvColor;
  end;
end;

//    
procedure TForm1.StTxtBColorClick(Sender: TObject);
begin
  if ColorDialog1.Execute
  then begin
    bColor := ColorDialog1.Color;   //  
    StTxtBColor.Color := bColor;
  end;
end;

//    
procedure TForm1.StTxtPColorClick(Sender: TObject);
begin
  if ColorDialog1.Execute
  then begin
    pColor := ColorDialog1.Color;   //  
    StTxtPColor.Color := pColor;
  end;
end;

// ,       
procedure TForm1.Image1MouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
   with Image1.Canvas do
   begin
     SavePenMode := Pen.Mode;       //   
     Pen.Mode    := pmNotXor;       //   NotXor
     Pen.Color   := pColor;
     Brush.Style := bsClear;        //   
   end;
   //   
   XB  := X;
   YB  := Y;
   XE  := X;
   YE  := Y;
   Elastic := True;
   ElasticShow := False;
   RqOrient := 'H';
end;

// ,      
procedure TForm1.Image1MouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
begin
   if Elastic = False then Exit;
   with Image1.Canvas do
   begin
     case CbBoxPicStyle.ItemIndex of
     0 : begin
           //   
           if ElasticShow
           then Rectangle(XB, YB, XE, YE);
           //   
           Rectangle(XB, YB, X, Y);
           ElasticShow := True;
         end;
     1 : begin
           //   
           if ElasticShow
           then begin
             MoveTo(XB, YB);
             LineTo(XE, YE);
           end;
           //   
           MoveTo(XB, YB);
           LineTo(X, Y);
           ElasticShow := True;
         end;
     2 : begin  // 
           if ElasticShow
           then begin
             case CbBoxREItem.ItemIndex of
             0: DrawRItem (Image1.Canvas, DrResH, XE, YE, RqOrient);
             1: DrawRItem (Image1.Canvas, DrCapH, XE, YE, RqOrient);
             end;
           end;
           //   
           if Shift * [ssAlt] = []
           then RqOrient := 'H'
           else RqOrient := 'V';
           case CbBoxREItem.ItemIndex of
             0: DrawRItem (Image1.Canvas, DrResH, X, Y, RqOrient);
             1: DrawRItem (Image1.Canvas, DrCapH, X, Y, RqOrient);
           end;
           ElasticShow := True;
         end;
     end; // of case
   end; // of with Image1.Canvas
   XE := X;
   YE := Y;
end;

// ,      
//     
procedure TForm1.Image1MouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
   Elastic := False;
   with Image1.Canvas do
   begin
     case CbBoxPicStyle.ItemIndex of
     0 : begin
           //   
           if ElasticShow
           then begin
               Rectangle(XB, YB, XE, YE);
               ElasticShow := False;
           end;
           //   
           Pen.Mode := SavePenMode;
           //  
           ShowFigure(XB, YB, X, Y);
         end;
     1 : begin
           //   
           if ElasticShow
           then begin
              MoveTo(XB, YB);
              LineTo(XE, YE);
              ElasticShow := False;
           end;
           //   
           Pen.Mode := SavePenMode;
           //  
           MoveTo(XB, YB);
           LineTo(X, Y);
         end;
         2 : begin  // 
           if ElasticShow
           then begin
             case CbBoxREItem.ItemIndex of
             0: DrawRItem (Image1.Canvas, DrResH, XE, YE, RqOrient);
             1: DrawRItem (Image1.Canvas, DrCapH, XE, YE, RqOrient);
             end;
           end;
           //   
           Pen.Mode := SavePenMode;
           case CbBoxREItem.ItemIndex of
             0: DrawRItem (Image1.Canvas, DrResH, X, Y, RqOrient);
             1: DrawRItem (Image1.Canvas, DrCapH, X, Y, RqOrient);
           end;
         end;
      end; // of case
   end;
end;

//   
procedure TForm1.FormCreate(Sender: TObject);
begin
  CbBoxPicStyle.ItemIndex := 0;
  CbBoxBStyle.ItemIndex   := 1;
  CbBoxFigure.ItemIndex   := 0;
  CbBoxREItem.ItemIndex   := 0;
  Elastic := false;
  CnvColor := Color;        //  
  bColor   := clSkyBlue;    //  
  pColor   := clNavy;       //  
  StTxtCnvColor.Color := CnvColor;
  StTxtBColor.Color := bColor;
  StTxtPColor.Color := pColor;
  ClearImage(Image1);
end;

end.
